'use strict'

module.exports = function parse(md) {

    function parse_paragraph(state, startLine/*, endLine*/) {

        var content, line, indents, terminate, i, l, token, oldParentType,
            nextLine = startLine + 1,
            terminatorRules = state.md.block.ruler.getRules('paragraph'),
            endLine = state.lineMax;

        oldParentType = state.parentType;
        state.parentType = 'paragraph';

        for (; nextLine < endLine && !state.isEmpty(nextLine); nextLine++) {
            if (state.sCount[nextLine] - state.blkIndent > 3) { continue; }

            if (state.sCount[nextLine] < 0) { continue; }

            terminate = false;
            for (i = 0, l = terminatorRules.length; i < l; i++) {
                if (terminatorRules[i](state, nextLine, endLine, true)) {
                    terminate = true;
                    break;
                }
            }
            if (terminate) { break; }
        }

        line = state.getLines(startLine, nextLine, state.blkIndent, false);

        content = line.trim();

        if (line.length > 0 && line.charCodeAt(0) == 0x3000) {
            indents = '&#x3000;';
            for (i = 1; i < line.length; i++) {
                if (line.charCodeAt(i) != 0x3000) {
                    break;
                }
                indents += '&#x3000;';
            }
            content = indents + content;
        }

        state.line = nextLine;

        token          = state.push('paragraph_open', 'p', 1);
        token.map      = [ startLine, state.line ];

        token          = state.push('inline', '', 0);
        token.content  = content;
        token.map      = [ startLine, state.line ];
        token.children = [];

        token          = state.push('paragraph_close', 'p', -1);

        state.parentType = oldParentType;

        return true;
    };

    md.block.ruler.before('paragraph', 'cc_parse_paragraph', parse_paragraph);
}
